VERSION 5.00
Begin VB.Form MainForm 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "EasyHID Template"
   ClientHeight    =   3315
   ClientLeft      =   5490
   ClientTop       =   4080
   ClientWidth     =   6015
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3315
   ScaleWidth      =   6015
   ShowInTaskbar   =   0   'False
   StartUpPosition =   2  'CenterScreen
   Begin VB.TextBox Text2 
      Height          =   375
      Left            =   1200
      MaxLength       =   16
      TabIndex        =   2
      Top             =   2040
      Width           =   2535
   End
   Begin VB.TextBox Text1 
      Height          =   375
      Left            =   1200
      MaxLength       =   16
      TabIndex        =   1
      Text            =   "Data To LCD"
      Top             =   600
      Width           =   2535
   End
   Begin VB.CommandButton BT_Send 
      Caption         =   "Send"
      Height          =   375
      Left            =   4200
      TabIndex        =   0
      Top             =   600
      Width           =   1215
   End
   Begin VB.Frame Frame1 
      Caption         =   "Send Data to PICMicro for Display LCD"
      Height          =   1095
      Left            =   840
      TabIndex        =   3
      Top             =   240
      Width           =   4815
   End
   Begin VB.Frame Frame2 
      Caption         =   "Return DATA from PICMicro to PC"
      Height          =   1095
      Left            =   840
      TabIndex        =   4
      Top             =   1680
      Width           =   4815
   End
   Begin VB.Label Label1 
      Caption         =   "ETT CO.,LTD"
      Height          =   255
      Left            =   4560
      TabIndex        =   5
      Top             =   3000
      Width           =   1335
   End
End
Attribute VB_Name = "MainForm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

' vendor and product IDs
Private Const VendorID = 9999
Private Const ProductID = 1

' read and write buffers
Private Const BufferInSize = 16
Private Const BufferOutSize = 16
Dim BufferIn(0 To BufferInSize) As Byte
Dim BufferOut(0 To BufferOutSize) As Byte

'*********************************************************
Option Explicit
Private Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (hpvDest As Any, hpvSource As Any, ByVal cbCopy As Long)

'The WideCharToMultiByte function maps a wide-character string to a new character string.
'The function is faster when both lpDefaultChar and lpUsedDefaultChar are NULL.

'CodePage
Private Const CP_ACP = 0 'ANSI
Private Const CP_MACCP = 2 'Mac
Private Const CP_OEMCP = 1 'OEM
Private Const CP_UTF7 = 65000
Private Const CP_UTF8 = 65001

'dwFlags
Private Const WC_NO_BEST_FIT_CHARS = &H400
Private Const WC_COMPOSITECHECK = &H200
Private Const WC_DISCARDNS = &H10
Private Const WC_SEPCHARS = &H20 'Default
Private Const WC_DEFAULTCHAR = &H40

Private Declare Function WideCharToMultiByte Lib "kernel32" (ByVal CodePage As Long, _
                                                    ByVal dwFlags As Long, _
                                                    ByVal lpWideCharStr As Long, _
                                                    ByVal cchWideChar As Long, _
                                                    ByVal lpMultiByteStr As Long, _
                                                    ByVal cbMultiByte As Long, _
                                                    ByVal lpDefaultChar As Long, _
                                                    ByVal lpUsedDefaultChar As Long) As Long


Private Function ByteArrayToString(Bytes() As Byte) As String
    Dim iUnicode As Long, i As Long, j As Long
    
    On Error Resume Next
    i = UBound(Bytes)
    
    If (i < 1) Then
        'ANSI, just convert to unicode and return
        ByteArrayToString = StrConv(Bytes, vbUnicode)
        Exit Function
    End If
    i = i + 1
    
    'Examine the first two bytes
    CopyMemory iUnicode, Bytes(0), 2
    
    If iUnicode = Bytes(0) Then 'Unicode
        'Account for terminating null
        If (i Mod 2) Then i = i - 1
        'Set up a buffer to recieve the string
        ByteArrayToString = String$(i / 2, 0)
        'Copy to string
        CopyMemory ByVal StrPtr(ByteArrayToString), Bytes(0), i
    Else 'ANSI
        ByteArrayToString = StrConv(Bytes, vbUnicode)
    End If
                    
End Function

Private Function StringToByteArray(strInput As String, _
                                Optional bReturnAsUnicode As Boolean = True, _
                                Optional bAddNullTerminator As Boolean = False) As Byte()
    
    Dim lRet As Long
    Dim bytBuffer() As Byte
    Dim lLenB As Long
    
    If bReturnAsUnicode Then
        'Number of bytes
        lLenB = LenB(strInput)
        'Resize buffer, do we want terminating null?
        If bAddNullTerminator Then
            ReDim bytBuffer(lLenB)
        Else
            ReDim bytBuffer(lLenB - 1)
        End If
        'Copy characters from string to byte array
        CopyMemory bytBuffer(0), ByVal StrPtr(strInput), lLenB
    Else
  
        lLenB = Len(strInput)
        If bAddNullTerminator Then
            ReDim bytBuffer(lLenB)
        Else
            ReDim bytBuffer(lLenB - 1)
        End If
        lRet = WideCharToMultiByte(CP_ACP, 0&, ByVal StrPtr(strInput), -1, ByVal VarPtr(bytBuffer(0)), lLenB, 0&, 0&)
    End If
    
    StringToByteArray = bytBuffer
    
End Function


Private Sub BT_Send_Click()

    Dim bAnsi() As Byte
    Dim bUni() As Byte
    Dim str As String
    Dim i As Long
    Dim DLCD As Byte
    Dim lang As Integer
     
    str = Text1.Text
    
    lang = Len(str)
    
If lang > 0 Then
    bAnsi = StringToByteArray(str, False)
       
    For i = 0 To 16
        BufferOut(i) = &H20    ' Insert space to LCD buffer
    Next i
         
    For i = LBound(bAnsi) To UBound(bAnsi)
        DLCD = bAnsi(i)
        BufferOut(i + 1) = DLCD
    Next
   
  BufferOut(0) = 0

  hidWriteEx VendorID, ProductID, BufferOut(0)
     
End If

End Sub

' ****************************************************************
' when the form loads, connect to the HID controller - pass
' the form window handle so that you can receive notification
' events...
'*****************************************************************
Private Sub Form_Load()
   ' do not remove!
   ConnectToHID (Me.hwnd)
End Sub

'*****************************************************************
' disconnect from the HID controller...
'*****************************************************************
Private Sub Form_Unload(Cancel As Integer)
   DisconnectFromHID
End Sub

'*****************************************************************
' a HID device has been plugged in...
'*****************************************************************
Public Sub OnPlugged(ByVal pHandle As Long)
   If hidGetVendorID(pHandle) = VendorID And hidGetProductID(pHandle) = ProductID Then
      ' ** YOUR CODE HERE **
   End If
End Sub

'*****************************************************************
' a HID device has been unplugged...
'*****************************************************************
Public Sub OnUnplugged(ByVal pHandle As Long)
   If hidGetVendorID(pHandle) = VendorID And hidGetProductID(pHandle) = ProductID Then
      ' ** YOUR CODE HERE **
   End If
End Sub

'*****************************************************************
' controller changed notification - called
' after ALL HID devices are plugged or unplugged
'*****************************************************************
Public Sub OnChanged()
   Dim DeviceHandle As Long
   
   ' get the handle of the device we are interested in, then set
   ' its read notify flag to true - this ensures you get a read
   ' notification message when there is some data to read...
   DeviceHandle = hidGetHandle(VendorID, ProductID)
   hidSetReadNotify DeviceHandle, True
End Sub

'*****************************************************************
' on read event...
'*****************************************************************
Public Sub OnRead(ByVal pHandle As Long)
   
   ' read the data (don't forget, pass the whole array)...
   If hidRead(pHandle, BufferIn(0)) Then
      ' ** YOUR CODE HERE **
      
      Text2.Text = Chr(Val(BufferIn(1)))
      Text2.Text = Text2.Text & Chr(Val(BufferIn(2)))
      Text2.Text = Text2.Text & Chr(Val(BufferIn(3)))
      Text2.Text = Text2.Text & Chr(Val(BufferIn(4)))
      Text2.Text = Text2.Text & Chr(Val(BufferIn(5)))
      Text2.Text = Text2.Text & Chr(Val(BufferIn(6)))
      Text2.Text = Text2.Text & Chr(Val(BufferIn(7)))
      Text2.Text = Text2.Text & Chr(Val(BufferIn(8)))
      Text2.Text = Text2.Text & Chr(Val(BufferIn(9)))
      Text2.Text = Text2.Text & Chr(Val(BufferIn(10)))
      Text2.Text = Text2.Text & Chr(Val(BufferIn(11)))
      Text2.Text = Text2.Text & Chr(Val(BufferIn(12)))
      Text2.Text = Text2.Text & Chr(Val(BufferIn(13)))
      Text2.Text = Text2.Text & Chr(Val(BufferIn(14)))
      Text2.Text = Text2.Text & Chr(Val(BufferIn(15)))
      Text2.Text = Text2.Text & Chr(Val(BufferIn(16)))
      
      ' first byte is the report ID, e.g. BufferIn(0)
      ' the other bytes are the data from the microcontrolller...
   End If
End Sub

'*****************************************************************
' this is how you write some data...
'*****************************************************************
Public Sub WriteSomeData()
   BufferOut(0) = 0   ' first by is always the report ID
   BufferOut(1) = 10  ' first data item, etc etc

   ' write the data (don't forget, pass the whole array)...
   hidWriteEx VendorID, ProductID, BufferOut(0)
End Sub
 
